FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"
S = "${WORKDIR}/git"

SRC_URI +=  "git://git@github.com/rdk-e/apparmor-profiles;protocol=ssh;nobranch=1;destsuffix=git/apparmor-profiles;name=apparmor-profiles"
SRC_URI +=  "git://github.com/rdkcentral/rdk-apparmor-profiles;protocol=https;nobranch=1;destsuffix=git/rdk-apparmor-profiles;name=rdk-apparmor-profiles"

SRCREV_apparmor-profiles = "685f9cdbaf01c3500a68d6ffc89b813ee259bb00"
SRCREV_rdk-apparmor-profiles = "1072ee15e3b3a59097e732f8b56a87ca04cb52ed"
SRCREV_FORMAT = "apparmor-profiles_rdk-apparmor-profiles"

PACKAGE_BEFORE_PN += "${PN}-optimized"
#SYSTEMD_SERVICE_${PN} = "apparmor.service"

DEPENDS += "virtual/kernel"
do_configure[depends] += "virtual/kernel:do_shared_workdir"

do_parse_kernel_config() {
    # Failing the build if apparmor Kernel config is not present
    if ! grep -q "CONFIG_SECURITY_APPARMOR=y" "${STAGING_KERNEL_BUILDDIR}/.config" || ! grep -q "CONFIG_SECURITY=y" "${STAGING_KERNEL_BUILDDIR}/.config"; then
        bbfatal "Apparmor is not enabled in kernel configuration, aborting build"
    fi
}
addtask do_parse_kernel_config after do_configure before do_compile

do_install_append () {
    install -d ${D}${sysconfdir}/apparmor/caps
    install -d ${D}${sysconfdir}/apparmor/cron
    install -d ${D}${sysconfdir}/apparmor/unconfined
    install -d ${D}${sysconfdir}/apparmor.d
    install -d ${D}${sysconfdir}/apparmor.d/unconfined

    if echo "${MACHINE_IMAGE_NAME}" | grep 'AX014AN'; then
       APPARMOR_MACHINE_PROFILE="AX014AN"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'AX061AEI'; then
       APPARMOR_MACHINE_PROFILE="AX061AEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'TX061AEI'; then
       APPARMOR_MACHINE_PROFILE="TX061AEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SKXI11'; then
       APPARMOR_MACHINE_PROFILE="SKXI11"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SCXI11AIC' || echo "${MACHINE_IMAGE_NAME}" | grep 'WNXI11AEI'; then
       APPARMOR_MACHINE_PROFILE="${@bb.utils.contains('DISTRO_FEATURES', 'flex2_rdk', 'SKXI11', 'SCXWNX', d)}"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SCXI11BEI'; then
       APPARMOR_MACHINE_PROFILE="SCXI11BEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'SKXI11BED'; then
       APPARMOR_MACHINE_PROFILE="SKXI11BED"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'COESST11AEI'; then
       APPARMOR_MACHINE_PROFILE="COESST11AEI"
    fi
    if echo "${MACHINE_IMAGE_NAME}" | grep 'COESST11BEI'; then
       APPARMOR_MACHINE_PROFILE="COESST11BEI"
    fi

    #installing apparmor profiles
    for i in ${S}/apparmor-profiles/RDKV/*; do
        name=$(basename "$i")
        if [  -e "${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/$name" ]; then
               sed -i -e :a -e '/^\n*$/{$d;N;ba' -e '}' ${S}/apparmor-profiles/RDKV/$name   # remove all trailing new lines
               sed -i '$ d' ${S}/apparmor-profiles/RDKV/$name   # remove the enclosing '}'
               cat ${S}/apparmor-profiles/RDKV/$name ${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/$name > ${D}${sysconfdir}/apparmor.d/$name
               sed -i '$a }' ${D}${sysconfdir}/apparmor.d/$name
        else
               install -m 0644 ${S}/apparmor-profiles/RDKV/$name ${D}${sysconfdir}/apparmor.d/
        fi
    done

    for i in ${S}/apparmor-profiles/profiles_unconfined_rdkv/*; do
        name=$(basename "$i")
        if [  -e "${S}/apparmor-profiles/profiles_unconfined_rdkv/$name" ]; then
              install -m 0644 ${S}/apparmor-profiles/profiles_unconfined_rdkv/$name ${D}${sysconfdir}/apparmor.d/unconfined/$name
        fi
    done
    
    if (echo "${APPARMOR_MACHINE_PROFILE}" | grep -q 'SKXI11') || (echo "${APPARMOR_MACHINE_PROFILE}" | grep -q 'SCXWNX') || (echo "${APPARMOR_MACHINE_PROFILE}" | grep -q 'SCXI11BEI') || (echo "${APPARMOR_MACHINE_PROFILE}" | grep -q 'COESST11'); then 
          install -m 0644 ${S}/apparmor-profiles/cron_default ${D}${sysconfdir}/apparmor/cron/
          install -m 0644 ${S}/apparmor-profiles/global_unconfined_ix ${D}${sysconfdir}/apparmor/unconfined/
          install -m 0644 ${S}/apparmor-profiles/global_unconfined_pix ${D}${sysconfdir}/apparmor/unconfined/
          install -m 0644 ${S}/apparmor-profiles/RDKV/etc.apparmor.apparmor_parse.sh ${D}${sysconfdir}/apparmor.d/
          install -m 0644 ${S}/apparmor-profiles/global_system_wide_rdkv ${D}${sysconfdir}/apparmor/global_system_wide
          install -m 0644 ${S}/apparmor-profiles/Apparmor_exclude_systemdservice.inc ${D}${sysconfdir}/apparmor/
    fi
    install -m 0644 ${S}/apparmor-profiles/default ${D}${sysconfdir}/apparmor/caps/
    install -m 0755 ${S}/apparmor-profiles/aar_telemetry_rdkv.sh   ${D}${sysconfdir}/apparmor/aar_telemetry.sh
    sed -i 's|^AA_DEFAULT=.*|AA_DEFAULT="/etc/apparmor/apparmor_defaults"|' ${D}${sysconfdir}/apparmor/aar_telemetry.sh
    install -m 0755 ${S}/apparmor-profiles/apparmor_parse_rdkv.sh   ${D}${sysconfdir}/apparmor/apparmor_parse.sh
    if [  -f "${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/apparmor_defaults" ]; then
              install -m 0644 ${S}/apparmor-profiles/profiles/video/${APPARMOR_MACHINE_PROFILE}/apparmor_defaults ${D}${sysconfdir}/apparmor/apparmor_defaults
    else
              install -m 0644 ${S}/apparmor-profiles/apparmor_defaults_rdkv  ${D}${sysconfdir}/apparmor/apparmor_defaults
    fi
    install -m 0644 ${S}/rdk-apparmor-profiles/apparmor.service ${D}${systemd_system_unitdir}/apparmor.service
    install -D -m 0644 ${S}/apparmor-profiles/apparmor.conf ${D}${systemd_system_unitdir}/apparmor.service.d/apparmor.conf

    if ${@bb.utils.contains('APPARMOR_MACHINE_PROFILE' , 'RDKTV/AML', 'true', 'false', d)}; then
        sed -i '/^Description=/a Before=pqserver.service tvserver.service subttxrend-app.service' ${D}${systemd_system_unitdir}/apparmor.service
    fi
}
FILES_${PN}-optimized = "${sysconfdir}/apparmor/parser.conf \
                         ${sysconfdir}/apparmor/subdomain.conf \
                         ${sysconfdir}/init.d/apparmor \
                         ${base_libdir}/apparmor/functions \
                         ${base_libdir}/apparmor/rc.apparmor.functions \
                         ${bindir}/aa-enabled \
                         ${bindir}/aa-exec"

FILES_${PN}_append = " ${systemd_system_unitdir}/apparmor.service.d/apparmor.conf"
